package ru.yandex.solomon.expression.expr.op.bin;

/**
 * @author Vladimir Gordiychuk
 */
public enum DoubleArithBinOp {
    PLUS("plus", "+") {
        @Override
        double apply(double left, double right) {
            return Double.isNaN(left) ? right : Double.isNaN(right) ? left : left + right;
        }
    },
    MINUS("minus", "-") {
        @Override
        double apply(double left, double right) {
            return Double.isNaN(left) ? -right : Double.isNaN(right) ? left : left - right;
        }
    },
    DIV("div", "/") {
        @Override
        double apply(double left, double right) {
            return left / right;
        }
    },
    MULTIPLY("multiply", "*") {
        @Override
        double apply(double left, double right) {
            return left * right;
        }
    };

    private String name;
    private String operator;

    DoubleArithBinOp(String name, String operator) {
        this.name = name;
        this.operator = operator;
    }

    abstract double apply(double left, double right);

    public double reverse(double left, double right) {
        return apply(right, left);
    }

    public String getName() {
        return name;
    }

    public String getOperator() {
        return operator;
    }
}
