package ru.yandex.solomon.expression.expr.op.bin;

import java.util.function.DoubleBinaryOperator;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueVector;

/**
 * @author Vladimir Gordiychuk
 */
public class SelOpArithVectorDouble implements SelOpProvider {

    static double[] vectorDoubleAndVectorDouble(PositionRange range, double[] left, double[] right,
                                                DoubleBinaryOperator op) {
        if (left.length != right.length) {
            throw new EvaluationException(range, "Vector size not equal: " + left.length + " != " + right.length);
        }

        double[] result = new double[left.length];
        for (int index = 0; index < result.length; index++) {
            result[index] = op.applyAsDouble(left[index], right[index]);
        }
        return result;
    }

    @Override
    public void provide(SelOpRegistry registry) {
        for (DoubleArithBinOp op : DoubleArithBinOp.values()) {
            add(registry, op);
        }
    }

    private void add(SelOpRegistry registry, DoubleArithBinOp op) {
        registry.add(SelOp.newBuilder()
            .name(op.getName())
            .operator(op.getOperator())
            .args(SelTypes.DOUBLE_VECTOR, SelTypes.DOUBLE_VECTOR)
            .returnType(SelTypes.DOUBLE_VECTOR)
            .handler(args -> {
                var left = args.get(0).castToVector().doubleArray();
                var right = args.get(1).castToVector().doubleArray();
                return new SelValueVector(vectorDoubleAndVectorDouble(args.getCallRange(),
                    left, right, op::apply));
            })
            .build());
    }
}
