package ru.yandex.solomon.expression.expr.op.bin;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.expression.version.SelVersion;

/**
 * @author Vladimir Gordiychuk
 */
public class SelOpArithVectorGraph implements SelOpProvider {
    private static SelValue[] vectorGraphAndVectorGraph(
            boolean singletonVectorLikeScalar,
            PositionRange range,
            SelValue[] left,
            SelValue[] right,
            DoubleArithBinOp op)
    {
        if (left.length == 0 || right.length == 0) {
            return new SelValue[0];
        }

        if (left.length == 1 && right.length == 1) {
            return new SelValue[]{SelOpArithGraph.graphAndGraph(range, left[0], right[0], op::apply)};
        }

        if (left.length == 1) {
            return SelOpArithGraph.forEachGraph(singletonVectorLikeScalar, range, right, left[0], op::reverse);
        }

        if (right.length == 1) {
            return SelOpArithGraph.forEachGraph(singletonVectorLikeScalar, range, left, right[0], op::apply);
        }

        return OneToOneMatcher.match(
            named(left),
            named(right),
            (a, b) -> SelOpArithGraph.graphAndGraph(range, a, b, op::apply));
    }

    private static NamedGraphData[] named(SelValue[] value) {
        var result = new NamedGraphData[value.length];
        for (int index = 0; index < value.length; index++) {
            result[index] = value[index].castToGraphData().getNamedGraphData();
        }
        return result;
    }

    @Override
    public void provide(SelOpRegistry registry) {
        for (DoubleArithBinOp op : DoubleArithBinOp.values()) {
            add(registry, op);
        }
    }

    private void add(SelOpRegistry registry, DoubleArithBinOp op) {
        registry.add(SelOp.newBuilder()
            .name(op.getName())
            .operator(op.getOperator())
            .args(SelTypes.GRAPH_DATA_VECTOR, SelTypes.GRAPH_DATA_VECTOR)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .handler((ctx, args) -> {
                var left = args.get(0).castToVector().valueArray();
                var right = args.get(1).castToVector().valueArray();
                boolean singletonVectorLikeScalar = SelVersion.GROUP_LINES_RETURN_VECTOR_2.since(ctx.getVersion());
                return new SelValueVector(SelTypes.GRAPH_DATA, vectorGraphAndVectorGraph(singletonVectorLikeScalar,
                        args.getCallRange(), left, right, op));
            })
            .build());
    }
}
