package ru.yandex.solomon.expression.expr.op.bin;

import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueBoolean;

/**
 * @author Vladimir Gordiychuk
 */
public class SelOpBinAnd implements SelOpProvider {

    @Override
    public void provide(SelOpRegistry registry) {
        registry.add(SelOp.newBuilder()
            .name("and")
            .operator("&&")
            .args(SelTypes.BOOLEAN, SelTypes.BOOLEAN)
            .returnType(SelTypes.BOOLEAN)
            .handler(args -> {
                var left = args.get(0).castToBoolean().getValue();
                var right = args.get(1).castToBoolean().getValue();
                return SelValueBoolean.of(left && right);
            })
            .build());
    }
}
