package ru.yandex.solomon.expression.expr.op.bin;

import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueBoolean;

/**
 * @author Vladimir Gordiychuk
 */
public class SelOpCompareDouble implements SelOpProvider {
    @Override
    public void provide(SelOpRegistry registry) {
        for (CompareBinOp op : CompareBinOp.values()) {
            registry.add(SelOp.newBuilder()
                .name(op.name)
                .operator(op.operator)
                .args(SelTypes.DOUBLE, SelTypes.DOUBLE)
                .returnType(SelTypes.BOOLEAN)
                .handler(args -> {
                    var left = args.get(0).castToScalar().getValue();
                    var right = args.get(1).castToScalar().getValue();
                    return SelValueBoolean.of(op.applyDouble(left, right));
                })
                .build());
        }
    }
}
