package ru.yandex.solomon.expression.expr.op.bin;

import java.util.List;

import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueString;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class SelOpConcat implements SelOpProvider {

    private SelValue concat(SelValue left, SelValue right) {
        var s1 = left.convertToString();
        var s2 = right.convertToString();
        return new SelValueString(s1 + s2);
    }

    private SelOp operation(SelType left, SelType right) {
        return SelOp.newBuilder()
            .operator("+")
            .name("concat")
            .args(left, right)
            .returnType(SelTypes.STRING)
            .handler(args -> concat(args.get(0), args.get(1)))
            .build();
    }

    @Override
    public void provide(SelOpRegistry registry) {
        List<SelType> types = List.of(SelTypes.BOOLEAN, SelTypes.DOUBLE);
        registry.add(operation(SelTypes.STRING, SelTypes.STRING));
        for (SelType type : types) {
            registry.add(operation(SelTypes.STRING, type));
            registry.add(operation(type, SelTypes.STRING));
        }
    }
}
