package ru.yandex.solomon.expression.expr.op.un;

import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueDouble;
import ru.yandex.solomon.expression.value.SelValueDuration;

/**
 * @author Stepan Koltsov
 */
public class ArithUnOpMinus implements SelOpProvider {

    @Override
    public void provide(SelOpRegistry registry) {
        registry.add(SelOp.newBuilder()
            .name("unary_minus")
            .operator("-")
            .args(SelTypes.DOUBLE)
            .returnType(SelTypes.DOUBLE)
            .handler(args -> {
                var source = args.get(0).castToScalar().getValue();
                return new SelValueDouble(-source);
            })
            .build());

        registry.add(SelOp.newBuilder()
            .name("unary_minus")
            .operator("-")
            .args(SelTypes.DURATION)
            .returnType(SelTypes.DURATION)
            .handler(args -> {
                var source = args.get(0).castToDuration().getDuration();
                return new SelValueDuration(source.negated());
            })
            .build());
    }
}
