package ru.yandex.solomon.expression.expr.op.un;

import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Stepan Koltsov
 */
public class ArithUnOpPlus implements SelOpProvider {
    @Override
    public void provide(SelOpRegistry registry) {
        registry.add(SelOp.newBuilder()
            .name("unary_plus")
            .operator("+")
            .args(SelTypes.DOUBLE)
            .returnType(SelTypes.DOUBLE)
            .handler(args -> args.get(0))
            .build());

        registry.add(SelOp.newBuilder()
            .name("unary_plus")
            .operator("+")
            .args(SelTypes.DURATION)
            .returnType(SelTypes.DURATION)
            .handler(args -> args.get(0))
            .build());
    }
}
