package ru.yandex.solomon.expression.expr.op.un;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelOp;
import ru.yandex.solomon.expression.expr.func.SelOpProvider;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueBoolean;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelOpNot implements SelOpProvider {

    @Override
    public void provide(SelOpRegistry registry) {
        registry.add(SelOp.newBuilder()
            .name("not")
            .operator("!")
            .args(SelTypes.BOOLEAN)
            .returnType(SelTypes.BOOLEAN)
            .handler(args -> {
                var source = args.get(0).castToBoolean().getValue();
                return SelValueBoolean.of(!source);
            })
            .build());
    }
}
