package ru.yandex.solomon.expression.type;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public abstract class SelType {
    @Override
    public abstract String toString();

    public boolean isBoolean() {
        return this instanceof SelTypeBoolean;
    }

    public boolean isDouble() {
        return this instanceof SelTypeDouble;
    }

    public boolean isDoubleVector() {
        return this.equals(SelTypes.DOUBLE_VECTOR);
    }

    public boolean isVector() {
        return this instanceof SelTypeVector;
    }

    public boolean isGraphDataVector() {
        return this.equals(SelTypes.GRAPH_DATA_VECTOR);
    }

    public boolean isGraphData() {
        return this instanceof SelTypeGraphData;
    }

    public boolean isString() {
        return this instanceof SelTypeString;
    }

    public boolean isDuration() {
        return this instanceof SelTypeDuration;
    }

    public boolean isInterval() {
        return this instanceof SelTypeInterval;
    }

    public boolean isLambda() {
        return this instanceof SelTypeLambda;
    }

    public boolean isObject() {
        return this instanceof SelTypeObject;
    }

    public boolean isSideEffect() {
        return this instanceof SelTypeSideEffect;
    }

    public SelTypeLambda lambda() {
        return (SelTypeLambda) this;
    }

    public SelTypeVector vector() {
        return (SelTypeVector) this;
    }
}
