package ru.yandex.solomon.expression.type;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelTypeLambda extends SelType {
    public final List<SelType> paramTypes;
    public final SelType returnType;

    public SelTypeLambda(List<SelType> paramTypes, SelType returnType) {
        this.paramTypes = paramTypes;
        this.returnType = returnType;
    }

    public SelType singleParam() {
        if (paramTypes.size() != 1) {
            throw new IllegalStateException("lambda expected to have single param, got: " + this);
        }
        return paramTypes.get(0);
    }

    @Override
    public String toString() {
        String paramTypes = this.paramTypes.stream().map(SelType::toString).collect(Collectors.joining(", "));
        return "fn(" + paramTypes + ") -> " + returnType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelTypeLambda that = (SelTypeLambda) o;

        if (!paramTypes.equals(that.paramTypes)) return false;
        return returnType.equals(that.returnType);
    }

    @Override
    public int hashCode() {
        int result = paramTypes.hashCode();
        result = 31 * result + returnType.hashCode();
        return result;
    }
}
