package ru.yandex.solomon.expression.type;

/**
 * @author Stepan Koltsov
 */
public class SelTypeVector extends SelType {
    public final SelType elementType;

    public SelTypeVector(SelType elementType) {
        this.elementType = elementType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelTypeVector that = (SelTypeVector) o;

        return elementType.equals(that.elementType);
    }

    @Override
    public int hashCode() {
        int result = SelTypeVector.class.hashCode();
        result = 31 * result + elementType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "vector of " + elementType;
    }
}
