package ru.yandex.solomon.expression.type;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelTypes {
    public static final SelTypeDouble DOUBLE = new SelTypeDouble();
    public static final SelTypeString STRING = new SelTypeString();
    public static final SelTypeGraphData GRAPH_DATA = new SelTypeGraphData();
    public static final SelTypeBoolean BOOLEAN = new SelTypeBoolean();
    public static final SelTypeDuration DURATION = new SelTypeDuration();
    public static final SelTypeObject OBJECT = new SelTypeObject();
    public static final SelTypeInterval INTERVAL = new SelTypeInterval();
    public static final SelTypeSideEffect SIDE_EFFECT = new SelTypeSideEffect();
    public static final SelTypeSelector SELECTOR = new SelTypeSelector();

    public static final SelTypeVector DOUBLE_VECTOR = new SelTypeVector(DOUBLE);
    public static final SelTypeVector STRING_VECTOR = new SelTypeVector(STRING);
    public static final SelTypeVector GRAPH_DATA_VECTOR = new SelTypeVector(GRAPH_DATA);
    public static final SelTypeVector BOOLEAN_VECTOR = new SelTypeVector(BOOLEAN);

    public static final List<SelTypeVector> ALL_VECTORS = List.of(
            DOUBLE_VECTOR,
            STRING_VECTOR,
            GRAPH_DATA_VECTOR,
            BOOLEAN_VECTOR
    );
}
