package ru.yandex.solomon.expression.value;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ArgsList {
    private final List<SelValueWithRange> args;
    private final PositionRange callRange;

    public ArgsList(PositionRange callRange, int sizeHint) {
        this.callRange = callRange;
        args = new ArrayList<>(sizeHint);
    }

    public ArgsList(PositionRange callRange, List<SelValueWithRange> args) {
        this.callRange = callRange;
        this.args = args;
    }

    public void add(Supplier<SelValue> value, PositionRange range) {
        args.add(new SelValueWithRange(value, range));
    }

    public SelValue get(int i) {
        return args.get(i).getValue();
    }

    public PositionRange getRange(int i) {
        return args.get(i).getRange();
    }

    public SelValueWithRange getWithRange(int i) {
        return args.get(i);
    }

    public PositionRange getCallRange() {
        return callRange;
    }

    public Stream<SelValue> stream() {
        return args.stream().map(SelValueWithRange::getValue);
    }

    public int size() {
        return args.size();
    }

    public ArgsList slice(int to) {
        return slice(0, to);
    }

    public ArgsList slice(int from, int to) {
        return new ArgsList(callRange, args.subList(from, to));
    }
}
