package ru.yandex.solomon.expression.value;

/**
 * @author Stepan Koltsov
 */
public class ListFormatShort {

    public interface ListAccessor {
        String get(int index);
    }

    public static String formatList(int size, ListAccessor listAccessor) {
        StringBuilder sb = new StringBuilder();

        sb.append("[");

        int i = 0;
        for (; i < 3 && i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(listAccessor.get(i));
        }

        if (size - i > 5) {
            sb.append(", ...");
            i = size - 3;
        }

        for (; i < size; ++i) {
            sb.append(", ");
            sb.append(listAccessor.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

}
