package ru.yandex.solomon.expression.value;

import ru.yandex.solomon.expression.type.SelType;

/**
 * @author Stepan Koltsov
 */
public abstract class SelValue {

    public abstract SelType type();

    public SelValueVector asSingleElementVector() {
        return new SelValueVector(type(), new SelValue[]{this});
    }

    @Override
    public final String toString() {
        return format();
    }

    public SelValueDouble castToScalar() {
        return (SelValueDouble) this;
    }

    public SelValueVector castToVector() {
        return (SelValueVector) this;
    }

    public SelValueBoolean castToBoolean() {
        return (SelValueBoolean) this;
    }

    public SelValueGraphData castToGraphData() {
        return (SelValueGraphData) this;
    }

    public SelValueInterval castToInterval() {
        return (SelValueInterval) this;
    }

    public SelValueDuration castToDuration() {
        return (SelValueDuration) this;
    }

    public SelValueString castToString() {
        return (SelValueString) this;
    }

    public SelValueLambda castToLambda() {
        return (SelValueLambda) this;
    }

    public SelValueObject castToObject() {
        return (SelValueObject) this;
    }

    public abstract String format();

    public String convertToString() {
        if (this instanceof SelValueString) {
            return ((SelValueString) this).getValue();
        } else if (this instanceof SelValueBoolean) {
            return Boolean.toString(((SelValueBoolean) this).getValue());
        } else if (this instanceof SelValueDouble) {
            return Double.toString(((SelValueDouble) this).getValue());
        } else {
            throw new IllegalArgumentException("cannot convert value to string: " + formatSummary());
        }
    }

    public String formatSummary() {
        return format();
    }

    @Override
    public abstract boolean equals(Object obj);

    @Override
    public abstract int hashCode();
}
