package ru.yandex.solomon.expression.value;

import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Stepan Koltsov
 */
public class SelValueBoolean extends SelValue {
    private final boolean value;

    private SelValueBoolean(boolean value) {
        this.value = value;
    }

    public static SelValueBoolean of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static final SelValueBoolean TRUE = new SelValueBoolean(true);
    public static final SelValueBoolean FALSE = new SelValueBoolean(false);

    public boolean getValue() {
        return value;
    }

    @Override
    public SelType type() {
        return SelTypes.BOOLEAN;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelValueBoolean that = (SelValueBoolean) o;

        if (value != that.value) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return (value ? 1 : 0);
    }

    @Override
    public String format() {
        return String.valueOf(value);
    }
}
