package ru.yandex.solomon.expression.value;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelValueDouble extends SelValue {
    private final double value;

    public SelValueDouble(double value) {
        this.value = value;
    }

    public double getValue() {
        return value;
    }

    @Override
    public SelType type() {
        return SelTypes.DOUBLE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelValueDouble that = (SelValueDouble) o;

        return Double.compare(that.value, value) == 0;

    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(value);
        return (int) (temp ^ (temp >>> 32));
    }

    @Override
    public String format() {
        return String.valueOf(value);
    }
}
