package ru.yandex.solomon.expression.value;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;
import ru.yandex.solomon.util.collection.array.LongArrayView;
import ru.yandex.solomon.util.time.InstantUtils;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelValueGraphData extends SelValue {
    private final NamedGraphData namedGraphData;

    public SelValueGraphData(NamedGraphData graphData) {
        this.namedGraphData = graphData;
    }

    public SelValueGraphData(GraphData graphData) {
        this(NamedGraphData.of(graphData));
    }

    @Override
    public SelType type() {
        return SelTypes.GRAPH_DATA;
    }

    @Override
    public String format() {
        return namedGraphData.toString();
    }

    @Override
    public String formatSummary() {
        GraphData graphData = namedGraphData.getGraphData();
        LongArrayView timestamps = graphData.getTimestamps();
        DoubleArrayView values = graphData.getValues();
        return ListFormatShort.formatList(timestamps.length(), i -> {
            return InstantUtils.millisecondsToSecondsString(timestamps.at(i)) + ":" + values.at(i);
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelValueGraphData that = (SelValueGraphData) o;

        return namedGraphData.equals(that.namedGraphData);
    }

    @Override
    public int hashCode() {
        return namedGraphData.hashCode();
    }

    @Deprecated
    public GraphData getGraphData() {
        return namedGraphData.getGraphData();
    }

    public NamedGraphData getNamedGraphData() {
        return namedGraphData;
    }
}
