package ru.yandex.solomon.expression.value;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelValueInterval extends SelValue {
    private final Interval interval;

    public SelValueInterval(Interval interval) {
        this.interval = interval;
    }

    public Interval getInterval() {
        return interval;
    }

    @Override
    public SelType type() {
        return SelTypes.INTERVAL;
    }

    @Override
    public String format() {
        return interval.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelValueInterval that = (SelValueInterval) o;

        return interval.equals(that.interval);
    }

    @Override
    public int hashCode() {
        return interval.hashCode();
    }
}
