package ru.yandex.solomon.expression.value;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstLambda;
import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.expression.expr.SelExpr;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypeLambda;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelValueLambda extends SelValue {
    public final List<SelType> paramTypes;
    public final List<String> paramNames;
    public final SelExpr body;

    public SelValueLambda(List<SelType> paramTypes, List<String> paramNames, SelExpr body) {
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
        this.body = body;
    }

    public String singleParamName(PositionRange range) {
        if (paramNames.size() != 1) {
            throw new EvaluationException(range, "expected single parameter only, but " + paramNames.size());
        }
        return paramNames.get(0);
    }

    @Override
    public SelType type() {
        return new SelTypeLambda(paramTypes, body.type());
    }

    @Override
    public String format() {
        return AstLambda.formatLambda(paramNames, body.format());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelValueLambda that = (SelValueLambda) o;

        if (!paramTypes.equals(that.paramTypes)) return false;
        if (!paramNames.equals(that.paramNames)) return false;
        return body.equals(that.body);
    }

    @Override
    public int hashCode() {
        int result = paramTypes.hashCode();
        result = 31 * result + paramNames.hashCode();
        result = 31 * result + body.hashCode();
        return result;
    }
}
