package ru.yandex.solomon.expression.value;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SelValueObject extends SelValue {

    private final Map<String, SelValue> object;

    public SelValueObject(Map<String, SelValue> object) {
        this.object = object;
    }

    public Map<String, SelValue> getObject() {
        return object;
    }

    @Override
    public SelType type() {
        return SelTypes.OBJECT;
    }

    @Override
    public String format() {
        String content = object.entrySet().stream()
            .map(entry -> entry.getKey() + ": " + entry.getValue())
            .collect(Collectors.joining(", "));

        return '{' + content + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelValueObject)) {
            return false;
        }
        SelValueObject that = (SelValueObject) o;
        return Objects.equals(object, that.object);
    }

    @Override
    public int hashCode() {
        return object.hashCode();
    }
}
