package ru.yandex.solomon.expression.value;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public abstract class SelValueSideEffect extends SelValue {

    private final boolean isTerminating;

    protected SelValueSideEffect(boolean isTerminating) {
        this.isTerminating = isTerminating;
    }

    public boolean isTerminating() {
        return isTerminating;
    }

    @Override
    public final SelType type() {
        return SelTypes.SIDE_EFFECT;
    }

}
