package ru.yandex.solomon.expression.value;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelValueStatus extends SelValueSideEffect {

    public static final SelValueStatus UNKNOWN = new SelValueStatus(Status.UNKNOWN, false);
    public static final SelValueStatus OK = new SelValueStatus(Status.OK, true);
    public static final SelValueStatus WARN = new SelValueStatus(Status.WARN, true);
    public static final SelValueStatus ALARM = new SelValueStatus(Status.ALARM, true);
    public static final SelValueStatus NO_DATA = new SelValueStatus(Status.NO_DATA, true);

    public enum Status {
        UNKNOWN,
        OK,
        WARN,
        ALARM,
        NO_DATA,
    }

    final private Status status;

    private SelValueStatus(Status status, boolean isTerminating) {
        super(isTerminating);
        this.status = status;
    }

    @Override
    public String format() {
        return "SelValueStatus{status=" + status + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelValueStatus that = (SelValueStatus) o;
        return status == that.status;
    }

    @Override
    public int hashCode() {
        return Objects.hash(status);
    }

}
