package ru.yandex.solomon.expression.value;

import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.SelLexer;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelValueString extends SelValue {
    private static final Pattern NO_QUOTE_PATTERN = SelLexer.IDENT_PATTERN;
    private final String value;
    private final boolean skipUnnecessaryQuote;

    public SelValueString(String value) {
        this.value = value;
        this.skipUnnecessaryQuote = false;
    }

    public SelValueString(String value, boolean skipUnnecessaryQuote) {
        this.value = value;
        this.skipUnnecessaryQuote = skipUnnecessaryQuote;
    }

    public String getValue() {
        return value;
    }

    @Override
    public SelType type() {
        return SelTypes.STRING;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder(value.length() * 2 + 2);
        boolean skip = skipUnnecessaryQuote && NO_QUOTE_PATTERN.matcher(value).matches();
        if (!skip) {
            sb.append('\'');
        }
        for (char c : value.toCharArray()) {
            if (c == '\'') {
                sb.append('\\');
            }
            sb.append(c);
        }
        if (!skip) {
            sb.append('\'');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return value.equals(((SelValueString) obj).value);
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }
}
