package ru.yandex.solomon.expression.value;

import java.util.ArrayList;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelValueVectorBuilder {

    @Nonnull
    private final SelType elementType;
    @Nullable
    private final DoubleArrayList doubles;
    @Nullable
    private final ArrayList<SelValue> values;

    public SelValueVectorBuilder(SelType elementType) {
        this.elementType = elementType;
        if (elementType == SelTypes.DOUBLE) {
            doubles = new DoubleArrayList();
            values = null;
        } else {
            doubles = null;
            values = new ArrayList<>();
        }
    }

    public SelValueVectorBuilder add(SelValue value) {
        if (doubles != null) {
            doubles.add(value.castToScalar().getValue());
        } else if (values != null) {
            if (!value.type().equals(elementType)) {
                throw new IllegalArgumentException("different types: " + value.type() + "!=" + elementType);
            }
            values.add(value);
        } else {
            throw new AssertionError("not double array and not typed array");
        }

        return this;
    }

    @Nonnull
    public SelValueVector build() {
        if (doubles != null) {
            return new SelValueVector(doubles.toDoubleArray());
        } else if (values != null) {
            return new SelValueVector(elementType, values.toArray(new SelValue[0]));
        } else {
            throw new AssertionError("not double array and not typed array");
        }
    }
}
