package ru.yandex.solomon.expression.value;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@NotThreadSafe
public class SelValueWithRange {
    private final Supplier<SelValue> valueSupplier;
    private SelValue value = null;
    private final PositionRange range;

    public SelValueWithRange(Supplier<SelValue> valueSupplier, PositionRange range) {
        this.valueSupplier = valueSupplier;
        this.range = range;
    }

    public SelValue getValue() {
        if (value != null) {
            return value;
        }
        return value = valueSupplier.get();
    }

    public PositionRange getRange() {
        return range;
    }
}
