package ru.yandex.solomon.expression.version;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum SelVersion {
    BASIC_1(1),
    GROUP_LINES_RETURN_VECTOR_2(2),
    HISTOGRAM_FUNCTIONS_DONT_MERGE_3(3),
    ;

    static {
        for (int i = 1; i < values().length; i++) {
            if (values()[i].number <= values()[i - 1].number) {
                throw new RuntimeException("versions should be ordered");
            }
        }
    }

    public static final SelVersion CURRENT = GROUP_LINES_RETURN_VECTOR_2;
    public static final SelVersion MAX = values()[values().length - 1];
    public static final SelVersion MIN = values()[0];

    public boolean since(SelVersion version) {
        return version.number >= this.number;
    }

    public boolean before(SelVersion version) {
        return !since(version);
    }

    private int number;

    public int getNumber() {
        return number;
    }

    SelVersion(int number) {
        this.number = number;
    }
}
