package ru.yandex.solomon.flags;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.Nullable;

/**
 * @author Vladimir Gordiychuk
 */
public class FeatureFlagHolderStub implements FeatureFlagsHolder {
    private final FeatureFlags defaultFlags = new FeatureFlags();
    private final ConcurrentMap<String, FeatureFlags> byProjectFlags = new ConcurrentHashMap<>();
    private final ConcurrentMap<Integer, FeatureFlags> byNumIdFlags = new ConcurrentHashMap<>();

    @Override
    public FeatureFlags flags(String projectId) {
        return byProjectFlags.getOrDefault(projectId, defaultFlags);
    }

    @Override
    public FeatureFlags flags(int numId) {
        return byNumIdFlags.getOrDefault(numId, defaultFlags);
    }

    @Override
    public FeatureFlags flags(String project, String cluster, String service) {
        return byProjectFlags.getOrDefault(project, defaultFlags);
    }

    @Override
    public String define(FeatureFlag flag, String project, String shardId, String cluster, String service) {
        return "";
    }

    public void setFlag(String projectId, FeatureFlag flag, boolean value) {
        byProjectFlags.compute(projectId, (key, prev) -> updateFlags(prev, flag, value));
    }

    public void setFlag(int numId, FeatureFlag flag, boolean value) {
        byNumIdFlags.compute(numId, (key, prev) -> updateFlags(prev, flag, value));
    }

    public void setDefaultFlag(FeatureFlag flag, boolean value) {
        defaultFlags.add(flag, value);
    }

    private FeatureFlags updateFlags(@Nullable FeatureFlags prev, FeatureFlag flag, boolean value) {
        if (prev == null) {
            var flags = new FeatureFlags();
            flags.add(flag, value);
            return flags;
        }
        var copy = new FeatureFlags(prev);
        copy.add(flag, value);
        return copy;
    }
}
