package ru.yandex.solomon.flags;

/**
 * FeatureFlagHolder
 * @author Vladimir Gordiychuk
 */
public interface FeatureFlagsHolder {
    FeatureFlags flags(String projectId);
    FeatureFlags flags(int numId);
    FeatureFlags flags(String project, String cluster, String service);
    String define(FeatureFlag flag, String project, String shardId, String cluster, String service);

    default boolean hasFlag(FeatureFlag flag, String projectId) {
        return flags(projectId).hasFlag(flag);
    }

    default boolean hasFlag(FeatureFlag flag, int numId) {
        return flags(numId).hasFlag(flag);
    }

    default boolean hasFlag(FeatureFlag flag, String project, String cluster, String service) {
        return flags(project, cluster, service).hasFlag(flag);
    }
}
