package ru.yandex.solomon.fetcher.client;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.salmon.fetcher.proto.FetcherApiProto.ShardsHealthResponse;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto.TResolveClusterRequest;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto.TResolveClusterResponse;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto.TargetsStatusRequest;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto.TargetsStatusResponse;


/**
 * @author Sergey Polovko
 */
public interface FetcherClient {

    Set<String> getKnownHosts();

    String getAnyAvailableHost();

    CompletableFuture<TargetsStatusResponse> targetsStatus(String host, TargetsStatusRequest request);

    CompletableFuture<ShardsHealthResponse> getFetcherShardsHealths(String host);

    CompletableFuture<TResolveClusterResponse> resolveCluster(String host, TResolveClusterRequest request);

    CompletableFuture<Void> reloadShard(String host, String projectId, String shardId, int shardNumId);
}
