package ru.yandex.solomon.fetcher.client;

import java.util.Optional;

import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.discovery.DiscoveryService;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.grpc.conf.GrpcConfigurationContext;
import ru.yandex.solomon.config.protobuf.rpc.TRpcClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;


/**
 * @author Sergey Polovko
 */
@Configuration
@Import({
        GrpcConfigurationContext.class
})
public class FetcherClientContext {

    @Bean
    FetcherClient fetcherClient(
        @Qualifier("FetcherClientConfig") TRpcClientConfig config,
        @Qualifier("ClientId") Optional<String> clientId,
        ThreadPoolProvider threadPoolProvider,
        ClientOptionsFactory clientOptionsFactory)
    {
        if (config.hasGrpcConfig()) {
            String clientIdStr = clientId.map(Strings::emptyToNull).orElse(null);

            return new FetcherClientGrpc(config.getGrpcConfig(), clientIdStr, threadPoolProvider, DiscoveryService.async(), clientOptionsFactory);
        }

        throw new IllegalStateException("bad FetcherClientConfig");
    }

}
