package ru.yandex.grpc.conf;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.cloud.auth.token.TokenProvider;
import ru.yandex.passport.tvmauth.TvmClient;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;


/**
 * @author Alexei Suleimanov
 */
@Configuration
public class GrpcConfigurationContext {
    private static final Logger logger = LoggerFactory.getLogger(GrpcConfigurationContext.class);

    @Bean
    public ClientOptionsFactory gprcConfigClientOptionsFactory(
            @Qualifier("tvmClient") Optional<TvmClient> tvmClientOptional,
            @Qualifier("authContextIamTokenProvider") Optional<TokenProvider> iamTokenProvider,
            ThreadPoolProvider threadpool) {
        return new ClientOptionsFactory(tvmClientOptional, iamTokenProvider, threadpool);
    }
}
