package ru.yandex.grpc.utils;

import javax.annotation.Nonnull;

import com.google.common.net.HostAndPort;

import ru.yandex.solomon.selfmon.failsafe.CircuitBreaker;
import ru.yandex.solomon.selfmon.failsafe.ExpMovingAverageCircuitBreaker;
import ru.yandex.solomon.selfmon.failsafe.NoOpCircuitBreaker;

/**
 * @author Vladimir Gordiychuk
 */
public class DefaultCircuitBreakerFactory implements CircuitBreakerFactory {

    public static final DefaultCircuitBreakerFactory INSTANCE = new DefaultCircuitBreakerFactory();

    @Nonnull
    @Override
    public CircuitBreaker create(HostAndPort address, GrpcClientOptions options) {
        if (options.getCircuitBreakerResetTimeoutMillis() <= 0 ||
            Double.compare(options.getCircuitBreakerFailureQuantileThreshold(), 0) == 0)
        {
            return NoOpCircuitBreaker.INSTANCE;
        }

        return new ExpMovingAverageCircuitBreaker(
                options.getCircuitBreakerFailureQuantileThreshold(),
                options.getCircuitBreakerResetTimeoutMillis()
        );
    }
}
