package ru.yandex.grpc.utils;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.CallCredentials;
import io.grpc.NameResolver;
import io.netty.channel.EventLoopGroup;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface GrpcClientOptions {
    boolean isUseTls();

    long getIdleTimeoutMillis();

    long getDefaultTimeoutMillis();

    int getMaxInboundMessageSizeInBytes();

    int getMaxOutboundMessageSizeInBytes();

    long getKeepAliveDelayMillis();

    long getKeepAliveTimeoutMillis();

    Optional<EventLoopGroup> getEventLoopGroup();

    Optional<Executor> getRpcExecutor();

    Optional<ScheduledExecutorService> getTimer();

    Optional<ExecutorService> getResponseHandlerExecutorService();

    Optional<ChannelFactory> getChannelFactory();

    Optional<CircuitBreakerFactory> getCircuitBreakerFactory();

    Optional<NameResolver.Factory> getNameResolverFactory();

    Optional<Supplier<CallCredentials>> getCallCredentialsSupplier();

    double getCircuitBreakerFailureQuantileThreshold();

    long getCircuitBreakerResetTimeoutMillis();

    MetricRegistry getMetricRegistry();

    String getClientId();

    long getInFlightLimitForEndpoint(String endpoint);

    List<LimiterOptions> getLimiterOptions();

    interface Builder {
        GrpcClientOptions build();
    }
}
