package ru.yandex.grpc.utils;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.Attributes;
import io.grpc.Grpc;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class GrpcUtils {
    public static String realOrRemoteIp(Attributes attributes) {
        SocketAddress address = attributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        if (!(address instanceof InetSocketAddress)) {
            return "";
        }
        String hostAddress = ((InetSocketAddress) address).getAddress().getHostAddress();
        // For IPv6 addresses specially
        if (hostAddress.contains("%")) {
            hostAddress = hostAddress.split("%")[0];
        }
        return hostAddress;
    }
}
