package ru.yandex.grpc.utils;

import javax.annotation.Nonnull;

import com.google.common.base.Strings;
import io.grpc.Metadata;

/**
 * @author Vladimir Gordiychuk
 */
public class Headers {
    private static final Metadata.Key<String> CLIENT_ID_V1 = Metadata.Key.of("clientId", Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CLIENT_ID_V2 = Metadata.Key.of("x-solomon-clientid", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> CREATED_AT_MS = Metadata.Key.of("x-solomon-created-at", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> CLIENT_ID = CLIENT_ID_V2;

    @Nonnull
    public static String getClient(Metadata metadata) {
        String client;
        client = metadata.get(CLIENT_ID_V2);
        if (!Strings.isNullOrEmpty(client)) {
            return client;
        }

        client = metadata.get(CLIENT_ID_V1);
        if (!Strings.isNullOrEmpty(client)) {
            return client;
        }

        return "unknown";
    }

    public static long getCreatedAt(Metadata metadata) {
        String createdAt = metadata.get(CREATED_AT_MS);
        if (Strings.isNullOrEmpty(createdAt)) {
            return 0;
        }

        return Long.parseLong(createdAt);
    }
}
