package ru.yandex.grpc.utils;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.net.HostAndPort;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class InProcessChannelFactory implements ChannelFactory {
    @Override
    public ManagedChannel createChannel(HostAndPort address, GrpcClientOptions options) {
        InProcessChannelBuilder channelBuilder = InProcessChannelBuilder.forName(address.toString())
                .usePlaintext()
                .maxInboundMessageSize(options.getMaxInboundMessageSizeInBytes());

        options.getRpcExecutor().ifPresent(channelBuilder::executor);
        return channelBuilder.build();
    }
}
