package ru.yandex.grpc.utils;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

import io.grpc.stub.StreamObserver;

/**
 * @author Vladimir Gordiychuk
 */
public class MultipleResponseStreamObserver<T> implements StreamObserver<T> {
    private final List<CompletableFuture<T>> results;
    private final AtomicInteger messageNum = new AtomicInteger(0);

    public MultipleResponseStreamObserver(List<CompletableFuture<T>> results) {
        this.results = results;
    }

    @Override
    public void onNext(T value) {
        int index = messageNum.getAndIncrement();
        results.get(index).complete(value);
    }

    @Override
    public void onError(Throwable t) {
        for (CompletableFuture<T> future : results) {
            if (future.isDone()) {
                continue;
            }

            future.completeExceptionally(t);
        }
    }

    @Override
    public void onCompleted() {
    }
}
