package ru.yandex.grpc.utils;

import java.util.concurrent.CompletableFuture;

import io.grpc.stub.StreamObserver;

/**
 * @author Vladimir Gordiychuk
 */
public class SingleResponseStreamObserver<T> implements StreamObserver<T> {
    private final CompletableFuture<T> completableFuture;

    public SingleResponseStreamObserver(CompletableFuture<T> completableFuture) {
        this.completableFuture = completableFuture;
    }

    @Override
    public void onNext(T value) {
        this.completableFuture.complete(value);
    }

    @Override
    public void onError(Throwable t) {
        completableFuture.completeExceptionally(t);
    }

    @Override
    public void onCompleted() {
        if (!this.completableFuture.isDone()) {
            this.completableFuture.complete(null);
        }
    }
}
