package ru.yandex.grpc.utils.client;

import javax.annotation.Nullable;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;

/**
 * @author Vladimir Gordiychuk
 */
public class FailingClientCall<ReqT, RespT> extends ClientCall<ReqT, RespT> {
    private final Status status;

    public FailingClientCall(Status status) {
        this.status = status;
    }

    @Override
    public void start(Listener<RespT> responseListener, Metadata headers) {
        responseListener.onClose(status, new Metadata());
    }

    @Override
    public void request(int numMessages) {
    }

    @Override
    public void cancel(@Nullable String message, @Nullable Throwable cause) {
    }

    @Override
    public void halfClose() {
    }

    @Override
    public void sendMessage(ReqT message) {
    }
}
