package ru.yandex.grpc.utils.client.interceptors;

import java.util.function.Supplier;

import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;

public class AddTokenInterceptor implements ClientInterceptor {
    private final Supplier<CallCredentials> callCredentialsSupplier;

    public AddTokenInterceptor(Supplier<CallCredentials> callCredentialsSupplier) {
        this.callCredentialsSupplier = callCredentialsSupplier;

    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        callOptions = callOptions.withCallCredentials(callCredentialsSupplier.get());
        return next.newCall(method, callOptions);
    }
}
