package ru.yandex.grpc.utils.client.interceptors;

import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;

import ru.yandex.grpc.utils.client.EndpointMetrics.EndpointMetric;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricClientStreamTracer extends ClientStreamTracer {
    private final EndpointMetric metrics;

    MetricClientStreamTracer(EndpointMetric metrics) {
        this.metrics = metrics;
    }

    @Override
    public void outboundMessage(int seqNo) {
        metrics.addOutboundMessage();
    }

    @Override
    public void inboundMessage(int seqNo) {
        metrics.addInboundMessage();
    }

    @Override
    public void outboundWireSize(long bytes) {
        metrics.addOutboundBytes(bytes);
    }

    @Override
    public void inboundWireSize(long bytes) {
        metrics.addInboundBytes(bytes);
    }

    public static class Factory extends ClientStreamTracer.Factory {
        private final EndpointMetric metrics;

        public Factory(EndpointMetric metrics) {
            this.metrics = metrics;
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(StreamInfo info, Metadata headers) {
            return new MetricClientStreamTracer(metrics);
        }
    }
}
