package ru.yandex.grpc.utils.server.interceptors;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;

import ru.yandex.grpc.utils.Headers;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricServerInterceptor implements ServerInterceptor {
    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata clientHeaders, ServerCallHandler<ReqT, RespT> next) {
        return next.startCall(new ForwardingServerCall.SimpleForwardingServerCall<>(call) {
            @Override
            public void sendHeaders(Metadata serverHeaders) {
                if (clientHeaders.containsKey(Headers.CREATED_AT_MS)) {
                    serverHeaders.put(Headers.CREATED_AT_MS, Long.toString(System.currentTimeMillis()));
                }
                super.sendHeaders(serverHeaders);
            }
        }, clientHeaders);
    }
}
