package ru.yandex.grpc.utils.client.interceptors;

import java.util.concurrent.ArrayBlockingQueue;

import io.grpc.Status;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc.HealthImplBase;
import io.grpc.stub.StreamObserver;

/**
 * @author Vladimir Gordiychuk
 */
public class HealthServiceStub extends HealthImplBase {
    public final ArrayBlockingQueue<Call> calls = new ArrayBlockingQueue<>(100);

    @Override
    public void check(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        calls.add(new Call(request, responseObserver));
    }

    public static record Call(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        void complete() {
            responseObserver.onNext(HealthCheckResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        void error(Status status) {
            responseObserver.onError(status.asRuntimeException());
        }
    }
}
