package ru.yandex.solomon.http.filters;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import ru.yandex.solomon.util.ExceptionUtils;
import ru.yandex.solomon.util.http.HttpUtils;


/**
 * @author Sergey Polovko
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE + 1)
public class BrokenPipeMuteFilter implements WebFilter {
    private static final Logger logger = LoggerFactory.getLogger("access");

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        try {
            return chain.filter(exchange);
        } catch (Exception e) {
            ServerHttpRequest request = exchange.getRequest();
            String remoteAddr = HttpUtils.realOrRemoteIp(request);
            String requestUri = HttpUtils.requestUri(request);

            if (ExceptionUtils.isBrokenPipe(e)) {
                logger.warn("broken pipe for {} address on {}", remoteAddr, requestUri);
                return Mono.empty(); // ignore error
            }

            logger.error("error {} for {} address on {}", e.getMessage(), remoteAddr, requestUri, e);
            return Mono.error(e);
        }
    }
}
