package ru.yandex.solomon.http.filters;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

/**
 * This filter fixes invalid 'Content-Type' header value appeared in GPN installation.
 * See https://st.yandex-team.ru/SOLOMON-6293 for more info.
 *
 * @author Sergey Polovko
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE + 2)
public class FixContentTypeHeader implements WebFilter {
    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();

        String contentType = headers.getFirst(HttpHeaders.CONTENT_TYPE);
        if (contentType != null) {
            int idx = contentType.indexOf(',');
            if (idx != -1) {
                var modifiedRequest = request.mutate()
                        .header(HttpHeaders.CONTENT_TYPE, contentType.substring(0, idx))
                        .build();

                var modifiedExchange = exchange.mutate()
                        .request(modifiedRequest)
                        .build();

                return chain.filter(modifiedExchange);
            }
        }
        return chain.filter(exchange);
    }
}
