package ru.yandex.solomon.http.filters;

import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.webflux.filters.RequestPatternChanger;

/**
 * @author Alexey Trushkin
 */
@Component
public class SolomonApiRequestPatternChanger implements RequestPatternChanger {

    @Override
    public String change(ServerHttpRequest request, String pattern) {
        // Necessary to support different endpoints with same patterns for Data API v2
        if ("/api/v2/projects/:projectId/sensors/data".equals(pattern)) {
            MediaType contentType = request.getHeaders().getContentType();
            String contentTypeSuffix = MediaType.TEXT_PLAIN.equals(contentType)
                    ? ":text"
                    : ":json";
            pattern += contentTypeSuffix;
        }
        return pattern;
    }
}
