package ru.yandex.solomon.idempotency;

import com.google.protobuf.Any;

import ru.yandex.solomon.core.container.ContainerType;


/**
 * @author Alexey Trushkin
 */
public record IdempotentOperation(
        String id,
        String containerId,
        ContainerType containerType,
        String operationType,

        String entityId,
        Any result,
        long completedAt
) {

    public final static String NO_OPERATION_ID = "NO_OPERATION_ID";
    public final static IdempotentOperation NO_OPERATION = new IdempotentOperation(
            NO_OPERATION_ID,
            NO_OPERATION_ID,
            ContainerType.PROJECT,
            NO_OPERATION_ID,
            NO_OPERATION_ID,
            Any.getDefaultInstance(),
            0);

    public boolean isNoOperation() {
        return this == IdempotentOperation.NO_OPERATION;
    }
}
