package ru.yandex.solomon.idempotency;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.core.db.YdbClientsContext;
import ru.yandex.solomon.idempotency.dao.IdempotentOperationDao;
import ru.yandex.solomon.idempotency.dao.ydb.YdbIdempotentOperationDao;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;

/**
 * @author Alexey Trushkin
 */
@Configuration
@Import({
        YdbClientsContext.class,
})
public class IdempotentOperationContext {
    private final String rootPath;
    private final TableClient tableClient;
    private final SchemeClient schemeClient;

    public IdempotentOperationContext(
            String rootPath,
            TableClient tableClient,
            SchemeClient schemeClient)
    {
        this.rootPath = rootPath;
        this.tableClient = tableClient;
        this.schemeClient = schemeClient;
    }

    @Bean
    IdempotentOperationDao idempotentOperationDao(MetricRegistry registry) {
        var dao = new YdbIdempotentOperationDao(rootPath, tableClient, schemeClient);
        dao.createSchemaForTests();
        return measure(dao, IdempotentOperationDao.class, registry);
    }

    @Bean
    IdempotentOperationService idempotentOperationService(IdempotentOperationDao dao)
    {
        return new IdempotentOperationServiceImpl(dao);
    }

    private <TDao> TDao measure(TDao dao, Class<TDao> daoClass, MetricRegistry registry) {
        return DaoMetricsProxy.of(dao, daoClass, registry);
    }
}
